/**
 * An abstract reference to a resource.
 * 
 * @author Michael D. Naper, Jr. <MichaelNaper.com>
 * @version 2013.01.17
 * @param <T>
 *          The type of resource referenced by this handle.
 */
public class Handle<T> {

  /**
   * Resource referenced by this handle.
   */
  protected T resource;

  /**
   * Constructs a new {@code Handle} referencing the specified resource.
   * 
   * @param resource
   *          The resource to be referenced by this handle.
   */
  public Handle(T resource) {
    this.resource = resource;
  }

  /**
   * Returns the resource referenced by this handle.
   * 
   * @return The resource referenced by this handle.
   */
  public T getResource() {
    return resource;
  }

  /**
   * Sets the resource referenced by this handle.
   * 
   * @param resource
   *          The resource to be referenced by this handle.
   */
  public void setResource(T resource) {
    this.resource = resource;
  }

  @Override
  public String toString() {
    return resource.toString();
  }

  @Override
  public int hashCode() {
    return resource.hashCode();
  }

  @Override
  public boolean equals(Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof Handle)) {
      return false;
    }
    Object otherResource = ((Handle<?>) obj).getResource();
    return resource == null ? otherResource == null : resource
        .equals(otherResource);
  }
}
