/**
 * Represents an insert command.
 * 
 * @author Michael D. Naper, Jr. <MichaelNaper.com>
 * @version 2013.01.17
 */
public class InsertCommand extends Command {

  // DNA string
  private final String dnaString;

  /**
   * Constructs a new {@code InsertCommand} with the specified DNA string.
   * 
   * @param dnaString
   *          The DNA string.
   */
  public InsertCommand(String dnaString) {
    super(Type.INSERT);

    this.dnaString = dnaString;

    if (this.dnaString == null) {
      throw new NullPointerException("dnaString is null.");
    }
  }

  /**
   * Returns the DNA string.
   * 
   * @return The DNA string.
   */
  public String getDnaString() {
    return dnaString;
  }

  @Override
  public void execute(Controller controller) {
    if (controller == null) {
      throw new NullPointerException("controller is null.");
    }

    controller.insertRecord(new DnaString(dnaString));
  }
}
