/**
 * A wrapper for a handle to a memory address.
 * 
 * @author Michael D. Naper, Jr. <MichaelNaper.com>
 * @version 2013.01.17
 */
public class MemoryHandle extends Handle<Integer> {

  /**
   * Constructs a new {@code MemoryHandle} referencing the specified memory
   * address.
   * 
   * @param address
   *          The memory address to be referenced by this handle.
   */
  public MemoryHandle(Integer address) {
    super(address);
    if (address == null) {
      throw new NullPointerException("address is null.");
    }
    if (address < 0) {
      throw new IllegalArgumentException(
          "address must be a non-negative integer.");
    }
  }

  @Override
  public void setResource(Integer address) {
    if (address == null) {
      throw new NullPointerException("address is null.");
    }
    if (address < 0) {
      throw new IllegalArgumentException(
          "address must be a non-negative integer.");
    }
    super.setResource(address);
  }

  @Override
  public boolean equals(Object obj) {
    if (!(obj instanceof MemoryHandle)) {
      return false;
    }
    return super.equals(obj);
  }
}
