/**
 * Represents a print command.
 * 
 * @author Michael D. Naper, Jr. <MichaelNaper.com>
 * @version 2013.01.17
 */
public class PrintCommand extends Command {

  // Type of print command
  private final PrintType printType;

  /**
   * Constructs a new {@code PrintCommand} with the specified {@link PrintType}.
   * 
   * @param type
   *          The type of print command.
   */
  public PrintCommand(PrintType type) {
    super(Type.PRINT);

    printType = type;

    if (this.printType == null) {
      throw new NullPointerException("printType is null.");
    }
  }

  /**
   * Returns the type of this print command.
   * 
   * @return The type of this print command.
   */
  public PrintType getPrintType() {
    return printType;
  }

  @Override
  public void execute(Controller controller) {
    if (controller == null) {
      throw new NullPointerException("controller is null.");
    }

    switch (printType) {
      case DEFAULT:
        controller.dumpContents();
        break;
      case LENGTHS:
        controller.dumpContentsWithLengths();
        break;
      case STATISTICS:
        controller.dumpContentsWithStatistics();
        break;
    }
  }

  /**
   * Represents all valid types of print commands.
   */
  public enum PrintType {

    DEFAULT(""), LENGTHS("lengths"), STATISTICS("stats");

    // Corresponds to identifying string in command file
    private final String name;

    PrintType(String name) {
      this.name = name;
    }

    @Override
    public String toString() {
      return name;
    }
  }
}
