/**
 * Represents a remove command.
 * 
 * @author Michael D. Naper, Jr. <MichaelNaper.com>
 * @version 2013.01.17
 */
public class RemoveCommand extends Command {

  // DNA string
  private final String dnaString;

  /**
   * Constructs a new {@code RemoveCommand} with the specified DNA string.
   * 
   * @param dnaString
   *          The DNA string.
   */
  public RemoveCommand(String dnaString) {
    super(Type.REMOVE);

    this.dnaString = dnaString;

    if (this.dnaString == null) {
      throw new NullPointerException("dnaString is null.");
    }
  }

  /**
   * Returns the DNA string.
   * 
   * @return The DNA string.
   */
  public String getDnaString() {
    return dnaString;
  }

  @Override
  public void execute(Controller controller) {
    if (controller == null) {
      throw new NullPointerException("controller is null.");
    }

    controller.removeRecord(new DnaString(dnaString));
  }
}
