/**
 * Represents a search command.
 * 
 * @author Michael D. Naper, Jr. <MichaelNaper.com>
 * @version 2013.01.17
 */
public class SearchCommand extends Command {

  // DNA string descriptor
  private final String dnaStringDescriptor;

  /**
   * Constructs a new {@code SearchCommand} with the specified DNA string
   * descriptor.
   * 
   * @param dnaStringDescriptor
   *          The DNA string descriptor.
   */
  public SearchCommand(String dnaStringDescriptor) {
    super(Type.SEARCH);

    this.dnaStringDescriptor = dnaStringDescriptor;

    if (this.dnaStringDescriptor == null) {
      throw new NullPointerException("dnaStringDescriptor is null.");
    }
  }

  /**
   * Returns the DNA string descriptor.
   * 
   * @return The DNA string descriptor.
   */
  public String getDnaStringDescriptor() {
    return dnaStringDescriptor;
  }

  @Override
  public void execute(Controller controller) {
    if (controller == null) {
      throw new NullPointerException("controller is null.");
    }

    controller.searchRecords(new DnaStringDescriptor(dnaStringDescriptor));
  }
}
