/**
 * Provides the functionality for an object to be serialized into and
 * deserialized from a byte array.
 * 
 * @author Michael D. Naper, Jr. <MichaelNaper.com>
 * @version 2013.01.17
 * 
 * @param <T>
 *          The type of object this serializer can serialize and deserialize.
 */
public interface Serializer<T> {

  /**
   * Serializes the specified object into a byte array.
   * 
   * @param object
   *          The object to serialize.
   * @return A byte array representing the object.
   */
  byte[] serialize(T object);

  /**
   * Returns an instance of the object represented by the specified byte array.
   * 
   * @param bytes
   *          The byte array representing the object.
   * @return An instance of the object represented by the specified byte array.
   * @throws InvalidBytesException
   *           If an invalid byte array is attempting to be deserialized.
   */
  T deserialize(byte[] bytes) throws InvalidBytesException;

  /**
   * Thrown to indicate that an invalid byte array is attempting to be
   * deserialized.
   */
  class InvalidBytesException extends Exception {

    private static final long serialVersionUID = 5127660591548707845L;

    /**
     * Constructs a new {@code InvalidBytesException}.
     */
    public InvalidBytesException() {
      super();
    }

    /**
     * Constructs a new {@code InvalidBytesException} with the specified detail
     * message.
     * 
     * @param message
     *          The detail message.
     */
    public InvalidBytesException(String message) {
      super(message);
    }
  }
}
