import static org.junit.Assert.*;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.regex.Pattern;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * @author Michael D. Naper, Jr. <MichaelNaper.com>
 * @version 2013.01.17
 */
public class DiskDnaTreeSetTest extends DnaTreeSetTest {

  private static final File DATA_FILE = new File(
      "DiskDnaTreeSetTest_DataFile.txt");
  private static final int BUFFER_POOL_CAPACITY = 2;
  private static final int BUFFER_POOL_BUFFER_SIZE = 3;
  private static final int INITIAL_MEMORY_POOL_SIZE = 0;
  private static final int MEMORY_POOL_EXPAND_LENGTH = 3;

  private BufferPool bufferPool;
  private FreeList freeList;

  @Before
  public void setUp() throws Exception {
    try {
      bufferPool = new BufferPool(DATA_FILE, BUFFER_POOL_CAPACITY,
          BUFFER_POOL_BUFFER_SIZE);
    } catch (FileNotFoundException e) {
      System.err.println("An I/O error occurred.");
      return;
    }
    MemoryPool memoryPool = new MemoryPool(bufferPool, INITIAL_MEMORY_POOL_SIZE);
    freeList = new FreeList();
    MemoryManager memoryManager = new MemoryManager(memoryPool, freeList,
        MEMORY_POOL_EXPAND_LENGTH);
    Serializer<DnaString> dnaStringSerializer = DnaStringSerializer
        .getInstance();
    dnaTreeSet = new DiskDnaTreeSet(memoryManager, dnaStringSerializer);
  }

  /**
   * @throws java.lang.Exception
   */
  @After
  public void tearDown() throws Exception {
    bufferPool.close();
    DATA_FILE.delete();
  }

  @Test
  public void testClear() {
    super.testClear();
    String freeListRegex = "\\[\\[0, [0-9]+\\] \\(([0-9]+) bytes\\)\\]";
    assertTrue("All memory should have been freed.",
        Pattern.matches(freeListRegex, freeList.toString()));
  }
}
