import static org.junit.Assert.*;

import org.junit.Before;
import org.junit.Test;

/**
 * @author Michael D. Naper, Jr. <MichaelNaper.com>
 * @version 2013.01.17
 */
public class DnaStringDescriptorTest {

  @Before
  public void setUp() throws Exception {}

  @Test
  public void testDnaStringDescriptorString() {
    assertNotNull(new DnaStringDescriptor("A"));
    assertNotNull(new DnaStringDescriptor("C"));
    assertNotNull(new DnaStringDescriptor("G"));
    assertNotNull(new DnaStringDescriptor("T"));
    assertNotNull(new DnaStringDescriptor("$"));
    assertNotNull(new DnaStringDescriptor("ACGT$"));
    try {
      assertNotNull(new DnaStringDescriptor("B"));
      fail("IllegalArgumentException should have been thrown.");
    } catch (IllegalArgumentException e) {
      // test passed
    }
    try {
      assertNotNull(new DnaStringDescriptor("ACG$T"));
      fail("IllegalArgumentException should have been thrown.");
    } catch (IllegalArgumentException e) {
      // test passed
    }
  }

  @Test
  public void testDnaStringDescriptorDnaString() {
    assertNotNull(new DnaStringDescriptor(new DnaString("A")));
  }

  @Test
  public void testGetDnaStringDescriptor() {
    String dnaStringDescriptor = "ACGT$";
    assertEquals("getDnaStringDescriptor returned incorrect string.",
        dnaStringDescriptor,
        new DnaStringDescriptor(dnaStringDescriptor).getDnaStringDescriptor());
  }

  @Test
  public void testMatches() {
    assertFalse("null should not match DnaStringDescriptor.",
        new DnaStringDescriptor("").matches(null));
    assertTrue("DnaString should match DnaStringDescriptor.",
        new DnaStringDescriptor("").matches(new DnaString("")));
    assertTrue("DnaString should match DnaStringDescriptor.",
        new DnaStringDescriptor("").matches(new DnaString("A")));
    assertTrue("DnaString should match DnaStringDescriptor.",
        new DnaStringDescriptor("$").matches(new DnaString("")));
    assertFalse("DnaString should not match DnaStringDescriptor.",
        new DnaStringDescriptor("$").matches(new DnaString("A")));
    assertTrue("DnaString should match DnaStringDescriptor.",
        new DnaStringDescriptor("A").matches(new DnaString("A")));
    assertTrue("DnaString should match DnaStringDescriptor.",
        new DnaStringDescriptor("A$").matches(new DnaString("A")));
    assertFalse("DnaString should not match DnaStringDescriptor.",
        new DnaStringDescriptor("A").matches(new DnaString("C")));
    assertTrue("DnaString should match DnaStringDescriptor.",
        new DnaStringDescriptor("A").matches(new DnaString("AC")));
    assertFalse("DnaString should not match DnaStringDescriptor.",
        new DnaStringDescriptor("A$").matches(new DnaString("AC")));
  }

  @Test
  public void testRemoveSpecialChars() {
    assertEquals("removeSpecialChars returned incorrect DnaStringDescriptor.",
        new DnaStringDescriptor("ACGT"),
        new DnaStringDescriptor("ACGT").removeSpecialChars());
    assertEquals("removeSpecialChars returned incorrect DnaStringDescriptor.",
        new DnaStringDescriptor(""),
        new DnaStringDescriptor("$").removeSpecialChars());
    assertEquals("removeSpecialChars returned incorrect DnaStringDescriptor.",
        new DnaStringDescriptor("ACGT"),
        new DnaStringDescriptor("ACGT$").removeSpecialChars());
  }

  @Test
  public void testToString() {
    String dnaStringDescriptor = "ACGT$";
    assertEquals("toString returned incorrect string.", dnaStringDescriptor,
        new DnaStringDescriptor(dnaStringDescriptor).toString());
  }

  @Test
  public void testHashCode() {
    String dnaStringDescriptor = "ACGT$";
    assertEquals("hashCode returned incorrect value.",
        dnaStringDescriptor.hashCode(), new DnaStringDescriptor(
            dnaStringDescriptor).hashCode());
  }

  @Test
  public void testEqualsObject() {
    String string = "ACGT$";
    DnaStringDescriptor dnaStringDescriptor = new DnaStringDescriptor(string);
    assertTrue("dnaStringDescriptor should be equal to itself.",
        dnaStringDescriptor.equals(dnaStringDescriptor));
    assertFalse("dnaStringDescriptor should not be equal to null.",
        dnaStringDescriptor.equals(null));
    assertFalse(
        "dnaStringDescriptor should not be equal to non-DnaStringDescriptor",
        dnaStringDescriptor.equals(new Object()));
    assertTrue("DnaStringDescriptors should be equal.",
        dnaStringDescriptor.equals(new DnaStringDescriptor(string)));
    assertFalse("DnaStringDescriptors should not be equal.",
        dnaStringDescriptor.equals(new DnaStringDescriptor("A" + string)));
  }
}
